IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_PDV_VD_IT_EXT_DESC]'))
	DROP VIEW [dbo].[V_PDV_VD_IT_EXT_DESC]
GO

SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[V_PDV_VD_IT_EXT_DESC]
AS
	SELECT
		CD_EMP
		,CD_FILIAL
		,CD_VD
		,CD_VEND
		,CD_PROD
		,CD_IT
		,DT_VD
		,ISNULL([SEM DESCONTO], 0)                          [SEM DESCONTO]
		,ISNULL([DESCONTO CADASTRO PRODUTO], 0)             [DESCONTO CADASTRO PRODUTO]
		,ISNULL([DESCONTO LOJA], 0)                         [DESCONTO LOJA]
		,ISNULL([DESCONTO CONVENIO], 0)                     [DESCONTO CONVENIO]
		,ISNULL([DESCONTO FIDELIDADE], 0)                   [DESCONTO FIDELIDADE]
		,ISNULL([DESCONTO PBM], 0)                          [DESCONTO PBM]
		,ISNULL([DESCONTO OFERTA], 0)                       [DESCONTO OFERTA]
		,ISNULL([DESCONTO VALOR FIDELIDADE], 0)             [DESCONTO VALOR FIDELIDADE]
		,ISNULL([DESCONTO CUPONAGEM], 0)                    [DESCONTO CUPONAGEM]
		,ISNULL([DESCONTO CRM], 0)                          [DESCONTO CRM]
		,ISNULL([DESCONTO POR TROCA DE PONTOS], 0)          [DESCONTO POR TROCA DE PONTOS]
		,ISNULL([DESCONTO ANIVERSARIO], 0)                  [DESCONTO ANIVERSARIO]
		,ISNULL([DESCONTO POR CLASSIFICACAO DE CLIENTE], 0) [DESCONTO POR CLASSIFICACAO DE CLIENTE]
		,ISNULL([ERRO SEM CLASSIFICACAO], 0)                [ERRO SEM CLASSIFICACAO]
		,ISNULL([DESCONTO PRECO DE FABRICA], 0)             [DESCONTO PRECO DE FABRICA]
		,ISNULL([DESCONTO POR QUANTIDADE], 0)               [DESCONTO POR QUANTIDADE]
		,ISNULL([DESCONTO PROMOCAO NO TELEVENDAS], 0)       [DESCONTO PROMOCAO NO TELEVENDAS]
		,ISNULL([DESCONTO CONVENIO COM RECEITA], 0)         [DESCONTO CONVENIO COM RECEITA]
		,ISNULL([DESCONTO BRINDE], 0)         [DESCONTO BRINDE]
		,ISNULL([DESCONTO FORMA DE PAGAMENTO], 0)         [DESCONTO FORMA DE PAGAMENTO]
		,ISNULL([DESCONTO CREDIARIO], 0)         [DESCONTO CREDIARIO]
		,ISNULL([DESCONTO CAMPANHA], 0)         [DESCONTO CAMPANHA]
		,ISNULL( [DESCONTO CONVENIO CUSTOMIZADO], 0)          [DESCONTO CONVENIO CUSTOMIZADO]
		,ISNULL( [DESCONTO MEDICAMENTO GRATUITO], 0)          [DESCONTO MEDICAMENTO GRATUITO]
		,ISNULL([DESCONTO PROGRAMADO], 0)         [DESCONTO PROGRAMADO]
		,ISNULL([DESCONTO PAGUE LEVE], 0)         [DESCONTO PAGUE LEVE]
		,ISNULL([DESCONTO FINANCEIRO NOTA FISCAL], 0)         [DESCONTO FINANCEIRO NOTA FISCAL]
		,ISNULL([DESCONTO PRE-VENCIDO], 0)         [DESCONTO PRE-VENCIDO]
		,ISNULL([DESCONTO POS-PBM], 0)         [DESCONTO POS-PBM]
		,ISNULL([DESCONTO ESPECIAL LISTA DE PRODUTOS CLIENTE], 0)         [DESCONTO ESPECIAL LISTA DE PRODUTOS CLIENTE]
		,ISNULL([DESCONTO CONVENIO/CREDIARIO FORMA DE PGTO], 0)         [DESCONTO CONVENIO/CREDIARIO FORMA DE PGTO]

	FROM
		(SELECT
			 i.CD_EMP
			 ,i.CD_FILIAL
			 ,i.CD_VD
			 ,i.DT_VD
			 ,i.CD_VEND
			 ,i.CD_PROD
			 ,i.CD_IT
			 ,CASE WHEN I.TIPO_DESCONTO = 0 THEN 'SEM DESCONTO'
				WHEN I.TIPO_DESCONTO = 1 THEN 'DESCONTO CADASTRO PRODUTO'
				WHEN I.TIPO_DESCONTO = 2 THEN 'DESCONTO LOJA'
				WHEN I.TIPO_DESCONTO = 3 THEN 'DESCONTO CONVENIO'
				WHEN I.TIPO_DESCONTO = 4 THEN 'DESCONTO FIDELIDADE'
				WHEN I.TIPO_DESCONTO = 5 THEN 'DESCONTO PBM'
				WHEN I.TIPO_DESCONTO = 6 THEN 'DESCONTO OFERTA'
				WHEN I.TIPO_DESCONTO = 7 THEN 'DESCONTO VALOR FIDELIDADE'
				WHEN I.TIPO_DESCONTO = 8 THEN 'DESCONTO CUPONAGEM'
				WHEN I.TIPO_DESCONTO = 9 THEN 'DESCONTO CRM'
				WHEN I.TIPO_DESCONTO = 10 THEN 'DESCONTO POR TROCA DE PONTOS'
				WHEN I.TIPO_DESCONTO = 11 THEN 'DESCONTO ANIVERSARIO'
				WHEN I.TIPO_DESCONTO = 12 THEN 'DESCONTO POR CLASSIFICACAO DE CLIENTE'
				WHEN I.TIPO_DESCONTO = 13 THEN 'DESCONTO PRECO DE FABRICA'
				WHEN I.TIPO_DESCONTO = 14 THEN 'DESCONTO POR QUANTIDADE'
				WHEN I.TIPO_DESCONTO = 15 THEN 'DESCONTO PROMOCAO NO TELEVENDAS'
				WHEN I.TIPO_DESCONTO = 16 THEN 'DESCONTO CONVENIO COM RECEITA'
				WHEN I.TIPO_DESCONTO = 17 THEN 'DESCONTO BRINDE'
				WHEN I.TIPO_DESCONTO = 18 THEN 'DESCONTO FORMA DE PAGAMENTO'
				WHEN I.TIPO_DESCONTO = 19 THEN 'DESCONTO CREDIARIO'
				WHEN I.TIPO_DESCONTO = 20 THEN 'DESCONTO CAMPANHA'
				WHEN I.TIPO_DESCONTO = 21 THEN 'DESCONTO CONVENIO CUSTOMIZADO'
				WHEN I.TIPO_DESCONTO = 22 THEN 'DESCONTO MEDICAMENTO GRATUITO'
				WHEN I.TIPO_DESCONTO = 23 THEN 'DESCONTO PROGRAMADO'
				WHEN I.TIPO_DESCONTO = 24 THEN 'DESCONTO PAGUE LEVE'
				WHEN I.TIPO_DESCONTO = 25 THEN 'DESCONTO FINANCEIRO NOTA FISCAL'
				WHEN I.TIPO_DESCONTO = 26 THEN 'DESCONTO PRE-VENCIDO'
				WHEN I.TIPO_DESCONTO = 27 THEN 'DESCONTO POS-PBM'
				WHEN I.TIPO_DESCONTO = 28 THEN 'DESCONTO ESPECIAL LISTA DE PRODUTOS CLIENTE'
				WHEN I.TIPO_DESCONTO = 29 THEN 'DESCONTO CONVENIO/CREDIARIO FORMA DE PGTO'
				ELSE 'ERRO SEM CLASSIFICACAO'
				END                                                                                        AS DS_TIPO_DESCONTO
			 ,  ABS(( ROUND(I.QT_IT * I.VLR_IT * I.TX_DESC / 100, 2) - ISNULL(I.VLR_DESC_VERBA, 0) ) + ( CASE WHEN ISNULL(I.VLR_PMC, 0) > I.VLR_IT THEN ( I.VLR_PMC - I.VLR_IT ) * I.QT_IT ELSE 0 END )) VLR_DESC
		 FROM
			 PDV_VD AS V
			 INNER JOIN DBO.PDV_VD_IT AS I ON
				 V.CD_EMP = I.CD_EMP AND
				 V.CD_FILIAL = I.CD_FILIAL AND
				 V.CD_VD = I.CD_VD AND 
				 V.DT_VD = I.DT_VD
		 WHERE
			I.CD_EMP = 1 AND
			V.ST_VD  = 0 AND
			I.ST_IT  = 1) AS TBL
		PIVOT (SUM(VLR_DESC)
					FOR TBL.DS_TIPO_DESCONTO IN ([SEM DESCONTO],
																			 [DESCONTO CADASTRO PRODUTO],
																			 [DESCONTO LOJA],
																			 [DESCONTO CONVENIO],
																			 [DESCONTO FIDELIDADE],
																			 [DESCONTO PBM],
																			 [DESCONTO OFERTA],
																			 [DESCONTO VALOR FIDELIDADE],
																			 [DESCONTO CUPONAGEM],
																			 [DESCONTO CRM],
																			 [DESCONTO POR TROCA DE PONTOS],
																			 [DESCONTO ANIVERSARIO],
																			 [DESCONTO POR CLASSIFICACAO DE CLIENTE],
																			 [ERRO SEM CLASSIFICACAO],
																			 [DESCONTO PRECO DE FABRICA],
																			 [DESCONTO POR QUANTIDADE],
																			 [DESCONTO PROMOCAO NO TELEVENDAS],
																			 [DESCONTO CONVENIO COM RECEITA], 
																			 [DESCONTO BRINDE],
																			 [DESCONTO FORMA DE PAGAMENTO],
																			 [DESCONTO CREDIARIO],
																			 [DESCONTO CAMPANHA],
																			 [DESCONTO CONVENIO CUSTOMIZADO],
																			 [DESCONTO MEDICAMENTO GRATUITO],
																			 [DESCONTO PROGRAMADO],
																			 [DESCONTO PAGUE LEVE],
																			 [DESCONTO FINANCEIRO NOTA FISCAL],
																			 [DESCONTO PRE-VENCIDO],
																			 [DESCONTO POS-PBM],
																			 [DESCONTO ESPECIAL LISTA DE PRODUTOS CLIENTE],
																			 [DESCONTO CONVENIO/CREDIARIO FORMA DE PGTO]
																			 )) AS PVT

GO 
